function [XImage,YImage,ZImage,allPSFs] = get_vectorPSF(parameters)
% This m file computes a vectorial PSF based on the input parameters

% (C) Copyright 2018
% All rights reserved
% Department of Imaging Physics
% Faculty of Applied Sciences
% Delft University of Technology
% Delft, The Netherlands   

% calculate pupil matrix
[XPupil,YPupil,wavevector,wavevectorzmed,Waberration,PupilMatrix] = get_pupil_matrix(parameters);

% calculate field matrix for focal stack
[XImage,YImage,ZImage,FieldMatrix] = get_field_matrix(PupilMatrix,wavevector,wavevectorzmed,parameters);

% calculation of (free dipole) PSF for the focal stack
allPSFs = get_freedipolepsf(FieldMatrix,parameters);

% 3D convolution of the PSFs with a bead
if isfield(parameters,'bead')
    if parameters.bead == true
        bead = create3DBead(parameters);
        allPSFs = convn(bead,allPSFs,'same');
%         [Mx,My,Mz] = size(allPSFs);
    end
end

end